<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Address extends Model 
{

    protected $table = 'addresses';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $guarded = array('id');
    protected $fillable = array('lat', 'lng', 'city', 'map_desc', 'user_id');

    public function user()
    {
        return $this->belongsTo('App\Models\User');
    }

}